﻿using System;
using Curse.Friends.Configuration;
using Curse.Friends.ImageManager;

namespace Curse.Friends.ImagesWebService.Contracts
{
    public class ImageMetadataResponse
    {
        public int Width { get; set; }

        public int TotalBytes { get; set; }

        public string MimeType { get; set; }

        public bool IsAnimated { get; set; }

        public string ImageType { get; set; }

        public int Height { get; set; }

        public string Filename { get; set; }

        public DateTime DateUploaded { get; set; }

        public string Url { get; set; }
        
        public static ImageMetadataResponse FromMetadata(ImageMetadata metadata, string url)
        {
            return new ImageMetadataResponse
            {
                DateUploaded = metadata.DateUploaded,
                Filename = metadata.Filename,
                Height = metadata.Height,
                ImageType = metadata.ImageType,
                IsAnimated = metadata.IsAnimated,
                MimeType = metadata.MimeType,
                TotalBytes = metadata.TotalBytes,
                Width = metadata.Width,
                Url = url
            };
        }
    }
}