﻿using System;
using Curse.CloudFlare;
using Curse.Friends.Configuration;
using Curse.Friends.ImageManager;
using Curse.Friends.ImagesWebService.Configuration;
using Curse.Friends.MicroService;

namespace Curse.Friends.ImagesWebService
{
    public class MvcApplication : MicroServiceApplication
    {
     
        protected override ConfigurationServices ConfigurationServices
        {
            get { return ConfigurationServices.Database; }
        }

        protected override ServiceHostType ServiceType
        {
            get { return ServiceHostType.ImageService; }
        }

        protected override string ServiceDescription
        {
            get { return "The images service manages stores, resizes and services images."; }
        }

        protected override bool OverrideHomeController
        {
            get { return true; }
        }

        protected override void CustomApplicationStartup()
        {
            ImageManager.ImageManager.Initialize();
            if (ImageServiceConfiguration.Instance.CloudFlareEnabled)
            {
                ImageCache.CacheDuration = TimeSpan.FromSeconds(30);
                CloudFlareApi.Initialize(ImageServiceConfiguration.Instance.CloudFlareApiKey, ImageServiceConfiguration.Instance.CloudFlareEmail);
            }
        }                    
    }
}
