﻿using Curse.Friends.Configuration;
using Curse.Friends.Jobs;
using Curse.Friends.JobService;
using Curse.Friends.Statistics;
using Curse.Friends.Statistics.Models;
using Curse.Logging;
using System;
using System.Diagnostics;
using System.ServiceProcess;

namespace Curse.Friends.WorkerService
{
    public partial class CurseJobService : ServiceBase
    {
        public CurseJobService()
        {
            InitializeComponent();
        }

        public void OnDebugStart()
        {
            OnStart(null);

        }

        public void OnDebugStop()
        {
            OnStop();
        }
                
        protected override void OnStart(string[] args)
        {          
            var sw = Stopwatch.StartNew();
            EventLog.WriteEntry("Job Service Starting", EventLogEntryType.Information);

            Logger.Init(new LoggerConfig(@"C:\Curse\Logs") {LogRetainCount = 100, MaxLogSize = Int32.MaxValue});
            
            FriendsLogManager.Initialize(Configuration.CurseVoiceService.LogDataPayloadType.FriendsJobService);
            Logger.Info("Job Service Starting");

             // Add the event handler for handling non-UI thread exceptions to the event. 
            AppDomain.CurrentDomain.UnhandledException += CurrentDomain_UnhandledException;

            ReallyStartService(sw);
        }

        void ReallyStartService(object o)
        {
            try
            {
                EventLog.WriteEntry("Initializing Configuration", EventLogEntryType.Information);
                StorageConfiguration.Initialize("FriendsService");                                
                EventLog.WriteEntry("Worker Server Starting", EventLogEntryType.Information);
                FriendsStatsManager.Initialize(FriendsHostType.WorkerService);

                Logger.Info("Running periodic stats job...");
                var job = new PeriodicStatisticsJob();
                try
                {
                    job.Run();
                }
                catch (Exception ex)
                {
                    Logger.Error(ex, "Failed to run statistics job!");
                }
                
                Logger.Info("Shutting down stats manager...");
                FriendsStatsManager.Shutdown();

                Logger.Info("Shutting down log manager");
                FriendsLogManager.Shutdown();

            }
            catch (Exception ex)
            {
                EventLog.WriteEntry("Failed to start: " + ex.Message, EventLogEntryType.Error);
                Logger.Error(ex, "Notification has failed to start, due to an unhandled exception.");
                throw;
            }
        }

        void CurrentDomain_UnhandledException(object sender, UnhandledExceptionEventArgs e)
        {
            var exception = e.ExceptionObject as Exception;
            Logger.Error(exception, "Service has crashed!");

            Logger.Info("Shutting down stats manager...");
            FriendsStatsManager.Shutdown();

            Logger.Info("Shutting down log manager");
            FriendsLogManager.Shutdown();
        }

        protected override void OnStop()
        {
            try
            {
                base.RequestAdditionalTime(30 * 1000);
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Failed to request additional time.");
            }

            try
            {
                JobServer.Stop();
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Failed to cleanly stop service.");
            }
            
        }
    }
}
