﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Xml.Serialization;
using Curse.Friends.Configuration;

namespace Curse.Friends.LoginsWebService.Configuration
{

    [XmlRoot("Service")]
    public class LoginsWebServiceConfiguration
    {
        public static readonly LoginsWebServiceConfiguration Current;

        static LoginsWebServiceConfiguration()
        {
            Current = ConfigurationHelper.LoadConfiguration<LoginsWebServiceConfiguration>(FriendsServiceConfiguration.Mode, "LoginsWebServiceConfiguration");
            var clientKeys = Current.TwitchLoginClientKeys.Split(';');            
            
            
            Current.TwitchLoginClientMap = new Dictionary<string, string>();
            foreach (var keyPair in clientKeys)
            {
                var splits = keyPair.Split(':');
                if (splits.Length != 2)
                {
                    throw new ConfigurationErrorsException("LoginsWebServiceConfiguration contains an invalid configuration value for TwitchLoginClientKeys");
                }

                Current.TwitchLoginClientMap[splits[0]] = splits[1];
            }
        }

        [XmlElement("AuthenticationServiceUrl")]
        public string AuthenticationServiceUrl { get; set; }

        [XmlElement("AuthenticationServiceSiteID")]
        public int AuthenticationServiceSiteID { get; set; }

        [XmlElement("AuthenticationServiceSiteKey")]
        public string AuthenticationServiceSiteKey { get; set; }

        [XmlElement("MaxAccountsPerIpPerHour")]
        public int MaxAccountsPerIpPerHour { get; set; }

        [XmlElement("EmailValidationRedirect")]
        public string EmailValidationRedirect { get; set; }

        [XmlElement("PremiumPromoThrough")]
        public long PremiumPromoThrough { get; set; }

        [XmlElement("TwitchLoginClientKeys")]
        public string TwitchLoginClientKeys { get; set; }
        
        [XmlElement("TwitchLoginHmacSecret")]
        public string TwitchLoginHmacSecret { get; set; }

        [XmlIgnore]
        public Dictionary<string, string> TwitchLoginClientMap { get; set; }

        [XmlArray("FuelScopes")]
        [XmlArrayItem("Scope")]
        public string[] FuelScopes { get; set; }
    }
}