﻿using System;
using System.Net.Mail;
using Curse.Extensions;
using Curse.Friends.MicroService;

namespace Curse.Friends.LoginsWebService.Contracts
{
    public class ClaimTempRequest : BaseRequestContract
    {
        public string TempAccountToken { get; set; }
        public string Email { get; set; }
        public string Password { get; set; }

        protected override bool DoValidate()
        {
            if (!Password.SafeRange(6, 32))
            {
                _validationMessage = "Password must be between 6 and 32 characters.";
                return false;
            }

            try
            {
                _validationMessage = "Invalid email address.";
                new MailAddress(Email);
            }
            catch (Exception)
            {
                return false;
            }
            
            return true;
        }
    }
}