﻿using Curse.Friends.TwitchApi;

namespace Curse.Friends.LoginsWebService.Contracts
{
    public class FuelAuthorizationResponseContract : ErrorableResponse
    {
        public string AccessToken { get; set; }

        public string RefreshToken { get; set; }

        public long Expires { get; set; }

        public string[] Scopes { get; set; }

        public static FuelAuthorizationResponseContract FromModel(FuelAuthorizationResponse value)
        {
            return new FuelAuthorizationResponseContract
            {
                AccessToken = value.AccessToken,
                Expires = value.Expires,
                RefreshToken = value.RefreshToken,
                Scopes = value.Scopes
            };
        }
    }
}