﻿using Curse.Friends.Enums;
using Curse.Friends.TwitchIdentityMerge;

namespace Curse.Friends.LoginsWebService.Contracts
{
    public class IdentityMergeStateContract
    {
        public int CurseUserID { get; set; }
        public string DisplayName { get; set; }
        public IdentityMergeFailureReason FailureReason { get; set; }
        public IdentityMergeStatus Status { get; set; }
        public string TwitchUserID { get; set; }
        public string Username { get; set; }

        public static IdentityMergeStateContract FromModel(IdentityMergeState model)
        {
            return new IdentityMergeStateContract
            {
                CurseUserID = model.CurseUserID,
                DisplayName = model.DisplayName,
                FailureReason = model.FailureReason,
                Status = model.Status,
                TwitchUserID = model.TwitchUserID,
                Username = model.Username
            };
        }
    }
}