﻿using Curse.Extensions;
using Curse.Friends.MicroService;

namespace Curse.Friends.LoginsWebService.Contracts
{
    public class LoginRequest : BaseRequestContract
    {
        public string Username { get; set; }
        public string Password { get; set; }

        protected override bool DoValidate()
        {
            if (!Username.SafeRange(1, 128))
            {
                return false;
            }

            if (!Password.SafeRange(1, 128))
            {
                return false;
            }

            return true;
        }
    }
}