﻿using System;
using Curse.Extensions;
using Curse.Friends.MicroService;
using System.Net.Mail;

namespace Curse.Friends.LoginsWebService.Contracts
{
    public class RegisterRequest : BaseRequestContract
    {
        public string Username { get; set; }
        public string Password { get; set; }
        public string Email { get; set; }
        public bool Newsletter { get; set; }

        protected override bool DoValidate()
        {
            if (!Username.SafeRange(2, 32))
            {
                _validationMessage = "Username must be between 2 and 32 characters.";
                return false;
            }

            if (!Password.SafeRange(6, 32))
            {
                _validationMessage = "Password must be between 6 and 32 characters.";
                return false;
            }
            
            try
            {
                _validationMessage = "Invalid email address.";
                new MailAddress(Email);
            }
            catch (Exception)
            {
                return false;
            }


            return true;
        }
    }
}