﻿using Curse.Extensions;
using Curse.Friends.MicroService;

namespace Curse.Friends.LoginsWebService.Contracts
{
    public class RegisterTempRequest : BaseRequestContract
    {
        public string Username { get; set; }
        protected override bool DoValidate()
        {
            if (!Username.SafeRange(2, 32))
            {
                _validationMessage = "Username must be between 2 and 32 characters.";
                return false;
            }
            
            return true;
        }
    }
}