﻿using Curse.Friends.MicroService;

namespace Curse.Friends.LoginsWebService.Contracts
{
    public class TwitchMergeExistingRequest : BaseRequestContract
    {
        public string MergeToken { get; set; }
        public string Username { get; set; }
        public string Password { get; set; }

        protected override bool DoValidate()
        {
            if (string.IsNullOrEmpty(MergeToken))
            {
                _validationMessage = "MergeToken not supplied";
                return false;
            }

            if (string.IsNullOrEmpty(Username))
            {
                _validationMessage = "Username not supplied";
                return false;
            }

            if (string.IsNullOrEmpty(Password))
            {
                _validationMessage = "Password not supplied";
                return false;
            }

            return true;
        }
    }
}