﻿using Curse.Friends.MicroService;

namespace Curse.Friends.LoginsWebService.Contracts
{
    public class TwitchMergeTempAccountRequest : BaseRequestContract
    {
        public string TempAccountToken { get; set; }
        public string MergeToken { get; set; }
        
        protected override bool DoValidate()
        {
            if (string.IsNullOrEmpty(MergeToken))
            {
                _validationMessage = "MergeToken not supplied";
                return false;
            }

            if (string.IsNullOrEmpty(TempAccountToken))
            {
                _validationMessage = "TempAccountToken not supplied";
                return false;
            }  
            return true;
        }
    }
}