﻿using Curse.Friends.MicroService;

namespace Curse.Friends.LoginsWebService.Contracts
{
    public class TwitchOAuthRequest : BaseRequestContract
    {
        public string ClientID { get; set; }
        public string Code { get; set; }

        public string RedirectUri { get; set; }

        public string State { get; set; }

        protected override bool DoValidate()
        {
            if (string.IsNullOrWhiteSpace(Code))
            {
                _validationMessage = "Code not supplied";
                return false;
            }

            if (string.IsNullOrWhiteSpace(ClientID))
            {
                _validationMessage = "ClientID not supplied";
                return false;
            }

            if (string.IsNullOrWhiteSpace(RedirectUri))
            {
                _validationMessage = "Redirect URI not supplied";
                return false;
            }

            return true;
        }
    }
}