﻿using Curse.Friends.LoginsWebService.Contracts;
using Curse.Friends.MicroService;
using Curse.Friends.TwitchApi;
using Curse.Friends.TwitchIdentityMerge;
using System.Web.Http;
using System.Web.Http.Description;

namespace Curse.Friends.LoginsWebService.Controllers
{
#if CONFIG_RELEASE
    [ApiExplorerSettings(IgnoreApi = true)]
#endif
    [AuthenticationFilter(AuthenticationLevel.ApiKey)]
    [RoutePrefix("logins/api")]
    public class LoginApiController : MicroServiceController
    {
        [HttpPost]
        [Route("provisioned/twitch/{twitchID}")]
        [ResponseType(typeof(IdentityMergeStateContract))]
        public IHttpActionResult AutoProvisionTwitchAccount(string twitchID)
        {
            TwitchUserInfo user;
            if(!TryGetPublicUser(twitchID, out user))
            {
                return InternalServerError();
            }

            var mergeState = IdentityMergeAuthHelper.ProvisionMappedUser(user, true);
            return Ok(IdentityMergeStateContract.FromModel(mergeState));
        }

        [HttpPost]
        [Route("twitch-unmerge/{twitchID}")]
        [ResponseType(typeof(void))]
        [AuthenticationFilter(AuthenticationLevel.ApiKey)]
        public IHttpActionResult TwitchUnmerge(int twitchID)
        {
            IdentityMergeAuthHelper.UnmergeAccount(twitchID);
            // Make the auth call to unmerge it
            return Ok();
        }

        private static bool TryGetPublicUser(string twitchID, out TwitchUserInfo publicUser)
        {
            var result = TwitchApiHelper.Default.GetPublicUser(twitchID);
            if (result.Status != TwitchResponseStatus.Success)
            {
                publicUser = null;
                return false;
            }

            publicUser = new TwitchUserInfo
            {
                UserID = result.Value.ID,
                Username = result.Value.Name,
                DisplayName = result.Value.DisplayName,
                Avatar = result.Value.Logo,
                Bio = result.Value.Bio,
            };
            return true;
        }
    }
}