﻿using Curse.Friends.Configuration;
using Curse.Friends.LoginsWebService.Authentication;
using Curse.Friends.LoginsWebService.Configuration;
using Curse.Friends.MicroService;
using Curse.Friends.TwitchApi;
using Curse.Logging;

namespace Curse.Friends.LoginsWebService
{
    public class WebApiApplication : MicroServiceApplication
    {
        protected override ServiceHostType ServiceType
        {
            get { return ServiceHostType.LoginsWebService; }
        }

        protected override string ServiceDescription
        {
            get { return "The logins service provides username and password authentication."; }
        }

        protected override ConfigurationServices ConfigurationServices
        {
            get { return ConfigurationServices.Database | ConfigurationServices.Queue; }
        }
       
        protected override void CustomApplicationStartup()
        {
            Logger.Info("Initializing Twitch API Helper...");
            TwitchApiHelper.Initialize(FriendsServiceConfiguration.Instance.TwitchClientID, null, LoginsWebServiceConfiguration.Current.TwitchLoginClientMap);

            Logger.Info("Initializing authentication provider...");
            LoginsAuthenticationProvider.Initialize(
                LoginsWebServiceConfiguration.Current.AuthenticationServiceUrl, 
                LoginsWebServiceConfiguration.Current.AuthenticationServiceSiteID, 
                LoginsWebServiceConfiguration.Current.AuthenticationServiceSiteKey);

        }
    }
}
