﻿using System;
using System.Net.Http.Headers;
using System.Web.Http.Filters;

namespace Curse.Friends.MicroService.Attributes
{
    public class CacheControlAttribute : ActionFilterAttribute
    {
        public int MaxAgeMinutes { get; set; }

        public CacheControlAttribute(int minutes = 30)
        {
            MaxAgeMinutes = minutes;
        }

        public override void OnActionExecuted(HttpActionExecutedContext context)
        {
            if (context != null && context.Response != null)
            {
                context.Response.Headers.CacheControl = new CacheControlHeaderValue()
                {
                    Public = true,
                    MaxAge = TimeSpan.FromMinutes(MaxAgeMinutes)
                };    
            }
            
            base.OnActionExecuted(context);
        }
    }
}