﻿
namespace Curse.Friends.MicroService
{
    public abstract class BaseRequestContract
    {
        protected internal string _validationMessage;

        protected internal abstract bool DoValidate();       

    }

    public abstract class BaseRequestContract<T> : BaseRequestContract
    {
        protected internal T _errorType;

        protected internal override bool DoValidate()
        {
            T errorType;
            return DoValidate(out errorType);
        }

        protected internal abstract bool DoValidate(out T errorType);
    }
}