﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;
using System.Xml.Serialization;
using Curse.Friends.Configuration;

namespace Curse.Friends.MicroService
{
    public static class ConfigHelper
    {
        private static string GetPath(ConfigurationMode mode, string configName)
        {
            var filename = string.Format("{0}.{1}.config", configName, mode);
            return FindFile(filename);
        }

        private static string FindFile(string filename)
        {
            var basePath = AppDomain.CurrentDomain.BaseDirectory;
            var filePath = Path.Combine(basePath, filename);
            if (File.Exists(filePath))
            {
                return filePath;
            }

            filePath = Path.Combine(basePath, "Configuration", filename);
            if (File.Exists(filePath))
            {
                return filePath;
            }

            filePath = Path.Combine(basePath, "bin", filename);
            if (File.Exists(filePath))
            {
                return filePath;
            }

            filePath = Path.Combine(basePath, "bin", "Configuration", filename);
            if (File.Exists(filePath))
            {
                return filePath;
            }

            throw new InvalidOperationException(string.Format("{0} could not be found in any expected location.", filename));
        }

        public static T LoadConfig<T>(ConfigurationMode mode, string configName)
        {
            var path = GetPath(mode, configName);
            var serializer = new XmlSerializer(typeof(T));
            return (T) serializer.Deserialize(File.OpenRead(path));
        }

        public static string[] ReadLines(string filename)
        {
            var path = FindFile(filename);
            return File.ReadAllLines(path);
        }
    }
}