﻿using System.Net;
using System.Net.Http;
using System.Web.Http;

namespace Curse.Friends.MicroService.Contracts
{
    public class ErrorResponse
    {
        public HttpStatusCode StatusCode { get; set; }

        public string ErrorType { get; set; }

        public string ErrorMessage { get; set; }

        public object Data { get; set; }

        public ErrorResponse(HttpStatusCode statusCode, string errorType, string errorMessage, object data = null)
        {
            StatusCode = statusCode;
            ErrorType = errorType;
            ErrorMessage = errorMessage;
            Data = data;
        }

        public static HttpContent Create(HttpRequestMessage request, HttpConfiguration config, HttpStatusCode statusCode, string errorType, string errorMessage, object data = null)
        {
            return ToHttpContent(request, config, new ErrorResponse(HttpStatusCode.Forbidden, errorType, errorMessage, data));
        }

        public HttpContent ToHttpContent(HttpRequestMessage request, HttpConfiguration config)
        {
            return ToHttpContent(request, config, this);
        }

        private static HttpContent ToHttpContent(HttpRequestMessage request, HttpConfiguration config, ErrorResponse content)
        {
            var negotiator = config.Services.GetContentNegotiator();
            var res = negotiator.Negotiate(typeof(ErrorResponse), request, config.Formatters);
            return new ObjectContent(typeof(ErrorResponse), content, res.Formatter);
        }
    }
}
