﻿using Curse.Friends.Data;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Web.Http.Filters;
using Newtonsoft.Json;

namespace Curse.Friends.MicroService.ExceptionHandlers
{
    public class DataValidationExceptionHandler : MicroServiceExceptionHandler<DataValidationException>
    {
        public override Task Handle(DataValidationException exception, HttpActionExecutedContext actionExecutedContext, CancellationToken cancellationToken)
        {
            var resp = new HttpResponseMessage(HttpStatusCode.BadRequest)
            {
                Content = new StringContent(JsonConvert.SerializeObject(exception.ToSerializeableObject()), Encoding.UTF8, "application/json")
            };
            actionExecutedContext.Response = resp;
            return Task.FromResult(0);
        }
    }
}
