﻿using System.Net;
using System.Threading;
using System.Threading.Tasks;
using System.Web.Http.Filters;
using System.Net.Http;
using System.Net.Http.Headers;
using Curse.Friends.MicroService.Exceptions;
using Newtonsoft.Json;

namespace Curse.Friends.MicroService.ExceptionHandlers
{
    public class FileUploadExceptionHandler : MicroServiceExceptionHandler<FileUploadException>
    {
        public override Task Handle(FileUploadException exception, HttpActionExecutedContext actionExecutedContext, CancellationToken cancellationToken)
        {

            HttpResponseMessage response;
            switch (exception.Reason)
            {
                case FileUploadFailureReason.TooManyBytes:
                    response = new HttpResponseMessage(HttpStatusCode.RequestEntityTooLarge);
                    break;
                case FileUploadFailureReason.TooManyUploads:
                    response = new HttpResponseMessage((HttpStatusCode)429) { ReasonPhrase = "Too Many Requests" };
                    break;
                default:
                    response = new HttpResponseMessage(HttpStatusCode.BadRequest);
                    break;
            }

            if (exception.RetryAfter.HasValue)
            {
                response.Headers.RetryAfter = new RetryConditionHeaderValue(exception.RetryAfter.Value);
            }

            if (!string.IsNullOrEmpty(exception.Message))
            {
                response.Content = new StringContent(JsonConvert.SerializeObject(exception.ToResponse()));
            }

            actionExecutedContext.Response = response;
            return Task.FromResult(0);
        }
    }
}
