﻿using System;
using System.Threading;
using System.Threading.Tasks;
using System.Web.Http.Filters;

namespace Curse.Friends.MicroService.ExceptionHandlers
{
    public abstract class MicroServiceExceptionHandler<T> : IMicroServiceExceptionHandler where T : Exception
    {
        public Type ExceptionType
        {
            get { return typeof (T); }
        }

        Task IMicroServiceExceptionHandler.Handle(Exception exception, HttpActionExecutedContext actionExecutedContext, CancellationToken cancellationToken)
        {
            return Handle((T)exception, actionExecutedContext, cancellationToken);
        }

        public abstract Task Handle(T exception, HttpActionExecutedContext actionExecutedContext, CancellationToken cancellationToken);
    }
}
