﻿using Curse.Friends.MicroService.Exceptions;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Web.Http.Filters;
using Newtonsoft.Json;

namespace Curse.Friends.MicroService.ExceptionHandlers
{
    public class RequestThrottledExceptionHandler : MicroServiceExceptionHandler<RequestThrottledException>
    {
        public override Task Handle(RequestThrottledException exception, HttpActionExecutedContext actionExecutedContext,
            CancellationToken cancellationToken)
        {
            actionExecutedContext.Response = new HttpResponseMessage(HttpStatusCode.Forbidden)
            {
                Content = new StringContent(JsonConvert.SerializeObject(new
                {
                    Error = exception.Message
                }))
            };
           
            
            return Task.FromResult(0);
        }
    }
}
