﻿using Curse.Friends.MicroService.Exceptions;
using System.Net;
using System.Net.Http;
using System.Threading;
using System.Threading.Tasks;
using System.Web.Http.Filters;
using Newtonsoft.Json;

namespace Curse.Friends.MicroService.ExceptionHandlers
{
    public class RequestValidationExceptionHandler : MicroServiceExceptionHandler<RequestValidationException>
    {
        public override Task Handle(RequestValidationException exception, HttpActionExecutedContext actionExecutedContext, CancellationToken cancellationToken)
        {
            actionExecutedContext.Response = new HttpResponseMessage(HttpStatusCode.BadRequest)
            {
                Content = new StringContent(JsonConvert.SerializeObject(exception.ToSerializableObject()))
            };
           
            
            return Task.FromResult(0);
        }
    }
}
