﻿using System.Net;
using System.Net.Http;
using System.Threading;
using System.Threading.Tasks;
using System.Web.Http.Filters;
using Curse.Friends.MicroService.Exceptions;

namespace Curse.Friends.MicroService.ExceptionHandlers
{
    public class UserNotFoundExceptionHandler : MicroServiceExceptionHandler<UserNotFoundException>
    {
        public override Task Handle(UserNotFoundException exception, HttpActionExecutedContext actionExecutedContext, CancellationToken cancellationToken)
        {
            actionExecutedContext.Response = new HttpResponseMessage(HttpStatusCode.NotFound);
            return Task.FromResult(0);
        }
    }
}
