﻿using System;

namespace Curse.Friends.MicroService.Exceptions
{
    public class RequestValidationException : Exception
    {
        public RequestValidationException(string message) : base(message)
        {
            
        }

        public virtual object ToSerializableObject()
        {
            return new { ValidationError = Message };
        }
    }

    public class RequestValidationException<T> : RequestValidationException
    {
        public T ErrorType { get; set; }

        public RequestValidationException(string message, T errorType) : base(message)
        {
            ErrorType = errorType;
        }

        public override object ToSerializableObject()
        {
            return new
            {
                Message,
                ErrorType
            };
        }
    }
}
