﻿using Curse.Friends.MicroService.Exceptions;
using Curse.Logging;

namespace Curse.Friends.MicroService
{
    public static class BaseRequestContractExtensions
    {
        public static void Validate(this BaseRequestContract request)
        {
            if (request == null)
            {
                throw new RequestValidationException("Missing required request contract.");
            }

            if (!request.DoValidate())
            {
                var validationMessage = request._validationMessage ?? "Unknown validation issue.";

#if !CONFIG_RELEASE
                Logger.Warn("Request failed validation: " + validationMessage, request);
#endif
                throw new RequestValidationException(validationMessage);
            }
        }

        public static void Validate<T>(this BaseRequestContract<T> request)
        {
            if (request == null)
            {
                throw new RequestValidationException<T>("Missing required request contract.", default(T));
            }

            T errorType;
            if (!request.DoValidate(out errorType))
            {
                var validationMessage = request._validationMessage ?? "Unknown validation issue.";

#if !CONFIG_RELEASE
                Logger.Warn("Request failed validation: " + validationMessage, request);
#endif
                throw new RequestValidationException<T>(validationMessage, errorType);
            }
        }
    }
}
