﻿using System.Net.Http;
using System.Linq;
using System;
using System.Collections.Generic;
using System.Net.Http.Headers;

namespace Curse.Friends.MicroService.Extensions
{
    public static class HttpRequestMessageExtensions
    {
        public static bool IsJsonRequest(this HttpRequestMessage value)
        {
            var acceptTypes = value.Headers.GetValues("Accept");
            if (acceptTypes != null && acceptTypes.Any(t => string.Equals(t, "application/json", StringComparison.InvariantCultureIgnoreCase)))
            {
                return true;
            }

            return false;
        }

        /// <summary>
        /// Returns an individual HTTP Header value
        /// </summary>
        /// <param name="request"></param>
        /// <param name="key"></param>
        /// <returns></returns>
        public static string GetHeader(this HttpRequestMessage request, string key)
        {
            IEnumerable<string> keys = null;
            if (!request.Headers.TryGetValues(key, out keys))
                return null;

            return keys.First();
        }

        /// <summary>
        /// Retrieves an individual cookie from the cookies collection
        /// </summary>
        /// <param name="request"></param>
        /// <param name="cookieName"></param>
        /// <returns></returns>
        public static string GetCookie(this HttpRequestMessage request, string cookieName)
        {
            CookieHeaderValue cookie = request.Headers.GetCookies(cookieName).FirstOrDefault();
            if (cookie != null)
                return cookie[cookieName].Value;

            return null;
        }
    }
}
