﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.Friends.MicroService.Extensions
{
    public static class StringExtensions
    {
        private static readonly HashSet<char> SafeCharacters = new HashSet<char>();

        static StringExtensions()
        {
            for (var c = '0'; c <= '9'; c++)
            {
                SafeCharacters.Add(c);
            }

            for (var c = 'A'; c <= 'Z'; c++)
            {
                SafeCharacters.Add(c);
            }

            for (var c = 'a'; c <= 'z'; c++)
            {
                SafeCharacters.Add(c);
            }

            SafeCharacters.Add('_');
            SafeCharacters.Add(' ');
            SafeCharacters.Add('-');
            SafeCharacters.Add('.');
        }

        public static string RemoveSpecialCharacters(this string value)
        {
            var filename = Path.GetFileNameWithoutExtension(value);
            var fileExtension = Path.GetExtension(value);

            if (filename == null || fileExtension == null)
            {
                return null;
            }

            var buffer = new char[filename.Length];
            var index = 0;

            foreach (var c in filename)
            {
                if (SafeCharacters.Contains(c))
                {
                    buffer[index] = c;
                    index++;
                }
            }

            filename = new string(buffer, 0, index).Trim(' ').Trim('-').Trim('.').Replace(" ", "-");
            return filename + fileExtension;
        }
    }
}
