﻿using Curse.Friends.Data;
using Curse.Friends.MicroService.Contracts;
using Curse.Logging;
using System;
using System.Net;
using System.Net.Http;
using System.Web.Http.Controllers;
using System.Web.Http.Filters;
using Curse.Friends.Enums;

namespace Curse.Friends.MicroService.Filters
{
    public class SocialBanFilterAttribute : ActionFilterAttribute
    {
        private static readonly LogCategory Logger = new LogCategory("Social Ban Filter") { Throttle = TimeSpan.FromSeconds(30), ReleaseLevel = LogLevel.Debug};

        public override void OnActionExecuting(HttpActionContext actionContext)
        {
            try
            {
                var token = AuthenticationContext.GetTokenFromRequest(actionContext.Request);
                if (token.UserID > 0 && UserBan.IsBannedFrom(token.UserID, UserBanType.Social))
                {
                    Logger.Debug("Detected user social ban.", new { token.UserID });
                    var errorResponse = new ErrorResponse(HttpStatusCode.Forbidden, "user_banned_social", "User is banned from social features");
                    actionContext.Response = new HttpResponseMessage(HttpStatusCode.Forbidden)
                    {
                        Content = errorResponse.ToHttpContent(actionContext.Request, actionContext.ActionDescriptor.Configuration)
                    };
                }
            }
            catch(Exception ex)
            {
                Logger.Warn(ex, "Failed to process ban. Bypassing filter");
            }

            base.OnActionExecuting(actionContext);
        }
    }
}
