﻿using System.Web.Http;
using System.Web.Http.Description;
using Curse.Friends.MicroService.Attributes;
using Curse.Friends.MicroService.Contracts;

namespace Curse.Friends.MicroService
{
    public abstract class MicroServiceUploadController : MicroServiceController
    {
        protected virtual string[] FileExtensionsFilter { get { return new string[0]; } }

        /// <summary>
        /// Gets the limits for what size/type of file can be uploaded to the service.
        /// </summary>
        /// <returns>The upload limits</returns>
        [Route("upload-limits")]
        [HttpGet]
        [ResponseType(typeof(UploadLimitsContract))]
        [IncludeInGenerator]
        [AuthenticationFilter(AuthenticationLevel.Anonymous)]
        public IHttpActionResult ServerLimits()
        {
            return Ok(new UploadLimitsContract
            {
                MaxFileSizeBytes = MicroServiceApplication.MaxContentLength,
                AllowedFileExtensions = FileExtensionsFilter
            });
        }

        protected override int MaxFileSize
        {
            get { return MicroServiceApplication.MaxContentLength; }
        }
    }
}
