﻿using Curse.SocketMessages;
using ProtoBuf;

namespace Curse.Friends.NotificationContracts
{
    [ProtoContract]
    [ServiceContract(ServiceContractDirection.Embedded)]
    public class AttachmentNotification : Contract<AttachmentNotification>
    {
        [ProtoMember(1)]
        public string ID
        {
            get;
            set;
        }

        [ProtoMember(2)]
        public string ConversationID
        {
            get;
            set;
        }

        [ProtoMember(3)]
        public string MessageID
        {
            get;
            set;
        }

        [ProtoMember(4)]
        public string Name
        {
            get;
            set;
        }

        [ProtoMember(5)]
        public string Title
        {
            get;
            set;
        }

        [ProtoMember(6)]
        public long Size
        {
            get;
            set;
        }

        [ProtoMember(7)]
        public string FileType
        {
            get;
            set;
        }

        [ProtoMember(8)]
        public string Url
        {
            get;
            set;
        }

        [ProtoMember(9)]
        public int Width
        {
            get;
            set;
        }

        [ProtoMember(10)]
        public int Height
        {
            get;
            set;
        }

        [ProtoMember(11)]
        public bool IsAnimated
        {
            get;
            set;
        }

        [ProtoMember(12)]
        public bool IsEmbed
        {
            get;
            set;
        }

        [ProtoMember(13)]
        public int AuthorID
        {
            get;
            set;
        }

        [ProtoMember(14)]
        public string AuthorName
        {
            get;
            set;
        }

        [ProtoMember(15)]
        public long Timestamp
        {
            get;
            set;
        }

        [ProtoMember(16)]
        public int RegionID
        {
            get; 
            set;
        }
    }
}
