﻿using Curse.SocketMessages;
using System;
using Curse.Friends.Enums;

namespace Curse.Friends.NotificationContracts
{
    /// <summary>
    /// Sent when a user invites another user to a call.
    /// </summary>    
    [ServiceContract(ServiceContractDirection.Response | ServiceContractDirection.Notification)]
    public class CallNotification : Contract<CallNotification>
    {
        /// <summary>
        /// The host name of the server to connect to
        /// </summary>
        public string HostName { get; set; }

        /// <summary>
        /// The IP Address of the server to connect to (Note: This is only used by legacy clients)
        /// </summary>
        public string IpAddress { get; set; }

        /// <summary>
        /// The AccessToken needed to join the call.
        /// Note: This token expires after a short period of time.
        /// </summary>
        public long AccessToken { get; set; }

        /// <summary>
        /// The unique ID of the voice host.
        /// </summary>
        public int HostID { get; set; }

        /// <summary>
        /// The region that this voice instance has been provisioned.
        /// </summary>
        public string RegionName { get; set; }

        /// <summary>
        /// The URL that can be used to invite other users to join the call.
        /// </summary>
        public string InviteUrl { get; set; }

        /// <summary>
        /// The short code used to identify the call for invites
        /// </summary>
        public string InviteCode { get; set; }

        /// <summary>
        /// The type of call (AdHoc, Friend, MultiFriend, etc)
        /// </summary>
        public CallType CallType { get; set; }

        /// <summary>
        /// The unique ID of the call. This should be used for all call management tasks
        /// </summary>
        public string CallID { get; set; }

        /// <summary>
        /// The unique ID of the conversation that this call is associated with. Note: this can be null.
        /// </summary>
        public string ConversationID { get; set; }

        /// <summary>
        /// The user ID of the creator
        /// </summary>
        public int CreatorID { get; set; }

        /// <summary>
        /// The username of the person that started the call
        /// Note: This can be null
        /// </summary>                                                 
        public string CreatorName { get; set; }

        /// <summary>
        /// The game ID that the call is associated with.
        /// Note: This can be null.
        /// </summary>
        public int? GameID { get; set; }

        /// <summary>
        /// The unique key associated with this voice session, if it is an automatch session.
        /// Note: This can be null.
        /// </summary>
        public long? AutoMatchKey { get; set; }

        public DateTime Timestamp { get; set; }

        /// <summary>
        /// The user ID of the person sending the call invite (this can be different than the creator ID, if you are adding someone to an existing call)
        /// </summary>
        public int SenderID { get; set; }

        /// <summary>
        /// The username of the person sending the call invite (this can be different than the creatorname, if you are adding someone to an existing call)
        /// </summary>
        public string SenderName { get; set; }

        /// <summary>
        /// Whether or not the client should force the user to disconnect from their current call and connect to this one.
        /// </summary>
        public bool ForceJoin { get; set; }

        /// <summary>
        /// Is this an audio or video call
        /// </summary>
        public CallMode Mode { get; set; }
    }
}
