﻿using System;
using Curse.Friends.Enums;
using Curse.SocketMessages;

namespace Curse.Friends.NotificationContracts
{
    /// <summary>
    /// When a user responds to a call invitation, this fans out to the group or the friend, depending on the type of the call
    /// </summary>
    [ServiceContract(ServiceContractDirection.Notification)]
    public class CallRespondedNotification : Contract<CallRespondedNotification>
    {
        /// <summary>
        /// The unique ID of the call
        /// </summary>
        public string CallID { get; set; }

        /// <summary>
        /// The invite code of the call
        /// </summary>
        public string InviteCode { get; set; }

        /// <summary>
        /// The full invite URL for the call
        /// </summary>
        public string InviteUrl { get; set; }

        /// <summary>
        /// The reason given for the response (Accepted, Declined, Busy, etc)
        /// </summary>
        public CallResponseReason Reason { get; set; }

        /// <summary>
        /// The ID of the user responding
        /// </summary>
        public int UserID { get; set; }

        /// <summary>
        /// The name of the user responding
        /// </summary>
        public string Username { get; set; }

        /// <summary>
        /// The timestamp of the response
        /// </summary>
        public DateTime Timestamp { get; set; }
    }
}
