﻿using System;
using System.Collections.Generic;
using Curse.Friends.Enums;
using Curse.SocketMessages;

namespace Curse.Friends.NotificationContracts
{
    [ServiceContract(ServiceContractDirection.Embedded)]    
    public class ChannelContract
    {
        public string GroupTitle { get; set; }
        public Guid GroupID { get; set; }
        public Guid ParentGroupID { get; set; }
        public Guid RootGroupID { get; set; }
        public string VoiceSessionCode { get; set; }
        public string MessageOfTheDay { get; set; }
        public GroupMode GroupMode { get; set; }
        public GroupType GroupType { get; set; }
        public GroupStatus GroupStatus { get; set; }
        public int DisplayOrder { get; set; }
        public Guid DisplayCategoryID { get; set; }
        public string DisplayCategory { get; set; }
        public int DisplayCategoryRank { get; set; }
        public bool AllowTemporaryChildGroups { get; set; }
        public bool ForcePushToTalk { get; set; }        
        public bool IsDefaultChannel { get; set; }
        public Dictionary<int, Int64> RolePermissions { get; set; }        
        public bool IsPublic { get; set; }
        public ChannelMembershipContract Membership { get; set; }
        public string UrlPath { get; set; }
        public GroupMemberContract[] VoiceMembers { get; set; }        
        public bool HideNoAccess { get; set; }
        public bool HideCallMembersNoAccess { get; set; }
        public string ExternalChannelID { get; set; }
    }
}