﻿using Curse.Friends.Enums;
using Curse.SocketMessages;

namespace Curse.Friends.NotificationContracts
{    
    [ServiceContract(ServiceContractDirection.Notification)]
    public class ConversationMessageNotification : Contract<ConversationMessageNotification>
    {
        
        public string ClientID { get; set; }
        public string ServerID { get; set; }
        public string ConversationID { get; set; }
        public string ContactID { get; set; }
        public ConversationType ConversationType { get; set; }
        public string RootConversationID { get; set; }        
        public long Timestamp { get; set; }
        public int SenderID { get; set; }
        public string SenderName { get; set; }
        public string SenderUsername { get; set; }
        public string SenderDisplayName { get; set; }
        public long SenderPermissions { get; set; }
        public int[] SenderRoles { get; set; }
        public int SenderVanityRole { get; set; }
        public int[] Mentions { get; set; }
        public int RecipientID { get; set; }
        public string Body { get; set; }
        public bool IsDeleted { get; set; }        
        public long DeletedTimestamp { get; set; }
        public int DeletedUserID { get; set; }
        public string DeletedUsername { get; set; }
        public long EditedTimestamp { get; set; }
        public int EditedUserID { get; set; }
        public string EditedUsername { get; set; }
        public int LikeCount { get; set; }
        public int[] LikeUserIDs { get; set; }
        public string[] LikeUsernames { get; set; }        
        public int[] ContentTags { get; set; }
        public AttachmentNotification[] Attachments { get; set; }
        public ConversationNotificationType NotificationType { get; set; }
        public ConversationMessageEmoteSubstitutionNotification[] EmoteSubstitutions { get; set; }
        public SpamConfidence SpamConfidence { get; set; }

        #region Twitch Chat Shim

        public string ExternalChannelID { get; set; }
        public string ExternalUserID { get; set; }
        public string ExternalUsername { get; set; }
        public string ExternalUserDisplayName { get; set; }
        public string ExternalUserColor { get; set; }
        public ConversationMessageBadgeContract[] Badges { get; set; }
        public int BitsUsed { get; set; }

        #endregion
    }

    [ServiceContract(ServiceContractDirection.Embedded)]
    public class ConversationMessageEmoteSubstitutionNotification
    {
        public string MessageText { get; set; }
        public long EmoteID { get; set; }
        public int EmoteSet { get; set; }
        public int StartIndex { get; set; }
        public int EndIndex { get; set; }
        public int EmoteHeight { get; set; }
        public int EmoteWidth { get; set; }
    }
}
