﻿using Curse.SocketMessages;
using ProtoBuf;
using System;
using Curse.Friends.Enums;

namespace Curse.Friends.NotificationContracts
{
    [ProtoContract]
    [ServiceContract(ServiceContractDirection.Response)]
    public class ConversationMessageResponse : Contract<ConversationMessageResponse>
    {
        [ProtoMember(1)]
        public string ConversationID
        {
            get;
            set;
        }

        [ProtoMember(3)]
        public DeliveryStatus Status
        {
            get;
            set;
        }        

        [ProtoMember(4)]
        public Guid ClientID
        {
            get;
            set;
        }

        [ProtoMember(5)]
        public Guid ServerID
        {
            get;
            set;
        }

        [ProtoMember(6)]
        public long? RetryAfter
        {
            get; 
            set;
        }

        [ProtoMember(7)]
        public MessageForbiddenReason ForbiddenReason { get; set; }

        [ProtoMember(8)]
        public GroupPermissions MissingPermission { get; set; }
    }
}
