﻿using Curse.SocketMessages;
using ProtoBuf;
using System;

namespace Curse.Friends.NotificationContracts
{
    [ProtoContract]
    [ServiceContract(ServiceContractDirection.Notification)]
    public class ConversationReadNotification : Contract<ConversationReadNotification>
    {
        [ProtoMember(1)]
        public Guid GroupID
        {
            get;
            set;
        }

        [ProtoMember(2)]
        public int FriendID
        {
            get;
            set;
        }

        [ProtoMember(3)]
        public DateTime Timestamp
        {
            get;
            set;
        }

        [ProtoMember(4)]
        public string ConversationID
        {
            get; 
            set;
        }

        [ProtoMember(5)]
        public bool MarkAllAsRead { get; set; }
    }
}
