﻿using System;
using Curse.Friends.Enums;
using Curse.SocketMessages;

namespace Curse.Friends.NotificationContracts
{
    [ServiceContract(ServiceContractDirection.Embedded)]
    public class ExternalCommunityMemberContract
    {
        public string ExternalUserID { get; set; }

        public string ExternalUsername { get; set; }

        public string ExternalUserDisplayName { get; set; }

        
        public string ExternalCommunityID { get; set; }

        public string ExternalCommunityName { get; set; }

        public AccountType ExternalCommunityType { get; set; }

        
        public GroupRoleTag ExternalCommunityRole { get; set; }

        public bool ExternalRoleIsActive { get; set; }

        public long ExternalRoleFirstTimestamp { get; set; }

        public long ExternalRoleCurrentTimestamp { get; set; }

        public int ExternalRoleEntryNumber { get; set; }


        public Guid GroupID { get; set; }

        public int UserID { get; set; }

        public string Username { get; set; }

        public int[] GroupRoles { get; set; }

        public GroupMemberContract GroupMember { get; set; }
    }
}
