﻿using System.Collections.Generic;
using Curse.Friends.Enums;
using Curse.SocketMessages;
using ProtoBuf;

namespace Curse.Friends.NotificationContracts
{
    [ProtoContract]
    [ServiceContract]
    public class FriendSuggestionContract
    {
        [ProtoMember(1)]
        public int FriendID
        {
            get;
            set;
        }

        [ProtoMember(2)]
        public string Username
        {
            get;
            set;
        }

        [ProtoMember(3)]
        public string AvatarUrl
        {
            get;
            set;
        }

        [ProtoMember(4)]
        public int FriendCount
        {
            get;
            set;
        }

        [ProtoMember(5)]
        public FriendSuggestionType Type
        {
            get;
            set;
        }

         [ProtoMember(6)]
        public int GameID
        {
            get;
            set;
        }

         [ProtoMember(7)]
        public FriendPlatform Platform
        {
            get;
            set;
        }

        [ProtoMember(8)]
        public long SuggestedTimestamp { get; set; }

        [ProtoMember(9)]
        public IEnumerable<int> FriendIDs { get; set; }
    }
}
