﻿using Curse.Friends.Enums;
using ProtoBuf;
using System;
using Curse.SocketMessages;

namespace Curse.Friends.NotificationContracts
{    
    [ServiceContract(ServiceContractDirection.Embedded)]
    public class FriendshipContract
    {                
                
        public FriendshipStatus Status
        {
            get;
            set;
        }
       
        public int OtherUserID
        {
            get;
            set;
        }

        public string OtherUsername
        {
            get;
            set;
        }

        public string OtherDisplayName
        {
            get;
            set;
        }
        
        public string OtherUserNickname
        {
            get;
            set;
        }

        public int OtherUserRegionID
        {
            get;
            set;
        }
        
        public UserConnectionStatus OtherUserConnectionStatus
        {
            get;
            set;
        }
        
        public string InvitationMessage
        {
            get;
            set;
        }
        
        public bool IsFavorite
        {
            get;
            set;
        }
        
        public string OtherUserStatusMessage
        {
            get;
            set;
        }
        
        public int OtherUserGameID
        {
            get;
            set;
        }
        
        public string OtherUserGameStatusMessage
        {
            get;
            set;
        }
        
        public int OtherUserGameState
        {
            get;
            set;
        }
        
        public DateTime OtherUserGameTimestamp
        {
            get;
            set;
        }
        
        public string OtherUserAvatarUrl
        {
            get;
            set;
        }
        
        public DateTime DateConfirmed
        {
            get;
            set;
        }
        
        public DateTime DateMessaged
        {
            get;
            set;
        }
        
        public DateTime DateRead
        {
            get;
            set;
        }
        
        public int UnreadCount
        {
            get;
            set;
        }
        
        public int MutualFriendCount
        {
            get;
            set;
        }
        
        public long OtherUserConnectionStatusTimestamp
        {
            get; 
            set;
        }
        
        public long RequestedTimestamp { get; set; }

        public long AvatarTimestamp { get; set; }

        public ClientCapability Capabilities { get; set; }

        public string OtherWatchingChannelID
        {
            get;
            set;
        }

        public string OtherWatchingChannelName
        {
            get;
            set;
        }

        public string OtherWatchingChannelUrl
        {
            get;
            set;
        }

        public int OtherBroadcastingGameID
        {
            get;
            set;
        }

        public bool OtherIsBroadcasting
        {
            get;
            set;
        }

        public string OtherUserTwitchID { get; set; }
    }
}
