﻿using Curse.SocketMessages;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Curse.Friends.NotificationContracts
{
    [ServiceContract(ServiceContractDirection.Notification)]
    public class GroupBulkMessageDeleteNotification : Contract<GroupBulkMessageDeleteNotification>
    {
        public Guid GroupID { get; set; }
        public int UserID { get; set; }
        public long StartMessageTimestamp { get; set; }
        public long EndMessageTimestamp { get; set; }
        public int DeletingUserID { get; set; }
        public string DeletingUserName { get; set; }


        public override bool Validate()
        {
            if(GroupID == default(Guid))
            {
                return false;
            }
            if(UserID == 0)
            {
                return false;
            }

            return base.Validate();
        }
    }
}
