﻿using System;
using Curse.Friends.Enums;
using Curse.SocketMessages;

namespace Curse.Friends.NotificationContracts
{    
    [EncryptedContract]
    [ServiceContract]
    public class GroupChangeNotification : Contract<GroupChangeNotification>
    {
        public GroupChangeNotification()
        {
            TimeStamp = DateTime.UtcNow;
        }

        /// <summary>
        /// The type of change affecting the group.
        /// </summary>        
        public GroupChangeType ChangeType { get; set; }

        /// <summary>
        /// The ID of the user that caused the change.
        /// </summary>        
        public int SenderID { get; set; }

        /// <summary>
        /// The Username of the user that caused the change.
        /// </summary>
        public string SenderName { get; set; }

        /// <summary>
        /// The group that has changed.
        /// </summary>        
        public GroupNotification Group { get; set; }


        // Used to prevent nulls
        private GroupMemberContract[] _members = new GroupMemberContract[0];

        /// <summary>
        /// The members affected by this change.
        /// </summary>
        /// <remarks>
        /// This field is only populated for GroupCreated, UsersAdded, UsersRemoved, and UsersUpdated changes.
        /// 
        /// GroupCreated notifications include the complete member list for Normal and Large Root groups.
        /// 
        /// UsersAdded, UsersRemoved, and UsersUpdated only include the affected members.
        /// </remarks>        
        public GroupMemberContract[] Members
        {
            get { return _members; }
            set { _members = value; }
        }

        /// <summary>
        /// When this change occurred.
        /// </summary>
        public DateTime TimeStamp { get; set; }

        // Used to prevent nulls
        private ChannelContract[] _childGroups = new ChannelContract[0];

        /// <summary>
        /// This child groups affected by this change.
        /// </summary>
        /// <remarks>
        /// This field is only populated for GroupReorganized changes and only includes changed child groups.
        /// </remarks>
        public ChannelContract[] ChildGroups
        {
            get { return _childGroups; }
            set { _childGroups = value; }
        }

        public GroupMemberRemovedReason RemovedReason { get; set; }

        public string MessageToUsers { get; set; }
    }
}
