﻿using System;
using System.Collections.Generic;
using Curse.Friends.Enums;
using Curse.SocketMessages;

namespace Curse.Friends.NotificationContracts
{
    [ServiceContract(ServiceContractDirection.Embedded)]
    public class GroupEventContract
    {
        public Guid RootGroupID { get; set; }

        public GroupEventCategory Category { get; set; }

        public GroupEventType Type { get; set; }

        public long Timestamp { get; set; }

        public int InitiatingUserID { get; set; }

        public string InitiatingUsername { get; set; }

        public GroupEventRootChangeFlags RootChangeFlags { get; set; }
        public GroupEventGroupContract PreviousRootGroupDetails { get; set; }
        public GroupEventGroupContract RootGroupDetails { get; set; }

        public GroupEventChannelChangeFlags ChannelChangeFlags { get; set; }
        public GroupEventChannelContract PreviousChannelDetails { get; set; }
        public GroupEventChannelContract ChannelDetails { get; set; }

        public GroupEventRoleChangeFlags RoleChangeFlags { get; set; }
        public GroupEventRoleContract PreviousRoleDetails { get; set; }
        public GroupEventRoleContract RoleDetails { get; set; }

        public GroupEventCommunityChangeFlags LinkedCommunityChangeFlags { get; set; }
        public GroupEventLinkedCommunityContract PreviousLinkedCommunityDetails { get; set; }
        public GroupEventLinkedCommunityContract LinkedCommunityDetails { get; set; }

        public GroupEventUserContract MemberDetails { get; set; }

        public GroupEventGiveawayContract GiveawayDetails { get; set; }

        public GroupEventPollContract PollDetails { get; set; }
    }

    [ServiceContract(ServiceContractDirection.Embedded)]
    public class GroupEventUserContract
    {
        public int UserID { get; set; }

        public string Username { get; set; }

        public int RoleID { get; set; }

        public string RoleName { get; set; }

        public GroupMemberRemovedReason? RemovedReason { get; set; }

        public string RemovedMessage { get; set; }
    }

    [ServiceContract(ServiceContractDirection.Embedded)]
    public class GroupEventGroupContract
    {
        public string Title { get; set; }

        public string MessageOfTheDay { get; set; }

        public int VoiceRegion { get; set; }

        public int AfkTimerMinutes { get; set; }

        public bool IsPublic { get; set; }

        public bool ChatThrottleEnabled { get; set; }

        public int ChatThrottleSeconds { get; set; }

        public bool IsSearchable { get; set; }

        public int[] SearchTags { get; set; }

        public int[] SearchGames { get; set; }

        public bool MatchAllGames { get; set; }

        public string SearchDescription { get; set; }
    }

    [ServiceContract(ServiceContractDirection.Embedded)]
    public class GroupEventChannelContract
    {
        public Guid ChannelID { get; set; }

        public string Title { get; set; }

        public string MessageOfTheDay { get; set; }

        public GroupType Type { get; set; }

        public bool IsPublic { get; set; }

        public int[] AccessRoles { get; set; }

        public int RoleID { get; set; }

        public string RoleName { get; set; }

        public Dictionary<int, int> PermissionsStates { get; set; }

        public GroupMode Mode { get; set; }
    }

    [ServiceContract(ServiceContractDirection.Embedded)]
    public class GroupEventRoleContract
    {
        public int RoleID { get; set; }

        public string Name { get; set; }

        public int Color { get; set; }

        public int Badge { get; set; }

        public int Rank { get; set; }

        public GroupPermissions Permissions { get; set; }
    }

    [ServiceContract(ServiceContractDirection.Embedded)]
    public class GroupEventPollContract
    {
        public int PollID { get; set; }

        public string Title { get; set; }

        public int TotalVotes { get; set; }

        public int[] RequiredRoles { get; set; }

        public int OptionsCount { get; set; }

        public string[] WinningOptions { get; set; }

        public int DurationMinutes { get; set; }

    }

    [ServiceContract(ServiceContractDirection.Embedded)]
    public class GroupEventGiveawayContract
    {
        public int GiveawayID { get; set; }

        public string Title { get; set; }

        public int Entries { get; set; }

        public int RollNumber { get; set; }

        public GroupGiveawayRollStatus? RollStatus { get; set; }

        public int WinnerUserID { get; set; }

        public string WinnerUsername { get; set; }

        public int WinnerBestRoleID { get; set; }

        public string WinnerBestRoleName { get; set; }

        public GroupGiveawayWinnerValidStatus? WinnerValidStatus { get; set; }
    }

    [ServiceContract(ServiceContractDirection.Embedded)]
    public class GroupEventLinkedCommunityContract
    {
        public string ExternalID { get; set; }

        public string ExternalName { get; set; }

        public bool SyncEmoticons { get; set; }

        public SyncedMemberGracePeriodAction? GracePeriodAction { get; set; }

        public int GracePeriodDays { get; set; }

        public bool IsStreaming { get; set; }
    }

}
