﻿using System;
using System.Collections.Generic;
using Curse.Friends.Enums;
using Curse.SocketMessages;

namespace Curse.Friends.NotificationContracts
{
    [ServiceContract(ServiceContractDirection.Embedded)]
    public class GroupGiveawayNotification
    {
        public Guid GroupID { get; set; }

        public int GiveawayID { get; set; }

        public string Title { get; set; }

        public int CreatorID { get; set; }

        public HashSet<int> RequiredRoles { get; set; }

        public Dictionary<int, int> RoleBonuses { get; set; }

        public int ResponseWindowSeconds { get; set; }

        public int SharingBonus { get; set; }

        public bool AllowRepeatWinners { get; set; }

        public bool AutoEnterActiveUsers { get; set; }

        public int RollsBeforeWinner { get; set; }

        public HashSet<int> AutoClaimRoles { get; set; }

        public HashSet<int> AutoEnterRoles { get; set; }

        public HashSet<int> IgnoredUsers { get; set; }

        public int Entries { get; set; }

        public int FakeRollsLeft { get; set; }

        public Dictionary<int, int> TopShares { get; set; }

        public GroupGiveawayStatus Status { get; set; }

        public int CurrentRollNumber { get; set; }

        public bool IncludeOfflineMembers { get; set; }
    }
}
