﻿using System;
using System.Collections.Generic;
using Curse.SocketMessages;
using Curse.Friends.Enums;

namespace Curse.Friends.NotificationContracts
{    
    [ServiceContract(ServiceContractDirection.Embedded)]
    public class GroupMembershipNotification
    {
        public string Nickname { get; set; }
        public bool CanChangeNickname { get; set; }
        public int BestRole { get; set; }
        public HashSet<int> Roles { get; set; }
        public DateTime DateJoined { get; set; }
        public DateTime DateMessaged { get; set; }
        public DateTime DateRead { get; set; }
        public DateTime DateRemoved { get; set; }
        public int UnreadCount { get; set; }
        public bool IsFavorite { get; set; }
        public NotificationPreference NotificationPreference { get; set; }
        public HashSet<string> NotificationFilters { get; set; }
        public DateTime NotificationMuteDate { get; set; }
        public bool IsVoiceMuted { get; set; }
        public bool IsVoiceDeafened { get; set; }
        public bool IsBanned { get; set; }
    }
}
