﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Curse.SocketMessages;
using ProtoBuf;

namespace Curse.Friends.NotificationContracts
{
    [ProtoContract]
    [EncryptedContract]
    [Obsolete]
    [ServiceContract]
    public class GroupMessageResponse : Contract<GroupMessageResponse>
    {   
        [ProtoMember(1)]
        public DeliveryStatus Status
        {
            get;
            set;
        }

        [ProtoMember(2)]
        public Guid GroupID
        {
            get;
            set;
        }

        [ProtoMember(3)]
        public string GroupName
        {
            get;
            set;
        }
        
        [ProtoMember(4)]
        public Guid ClientID
        {
            get;
            set;
        }

        [ProtoMember(5)]
        public string ClientName
        {
            get; 
            set; 
        }

        public GroupMessageResponse(GroupMessageRequest req)
        {
            GroupID = req.GroupID;
            ClientID = req.ClientID;
            ClientName = req.ClientName;
            GroupName = req.GroupName;
        }

        public GroupMessageResponse() { }
    }
}
