﻿using System;
using System.Collections.Generic;
using Curse.Friends.Enums;
using Curse.SocketMessages;

namespace Curse.Friends.NotificationContracts
{    
    [ServiceContract(ServiceContractDirection.Embedded)]
    public class GroupNotification
    {
        /// <summary>
        /// This group's title.
        /// </summary> 
        public string GroupTitle
        {
            get;
            set;
        }

        /// <summary>
        /// The ID of this group (Metadata).
        /// </summary>
        public Guid GroupID
        {
            get;
            set;
        }

        /// <summary>
        /// The numerical ID of the home region
        /// </summary>
        public int HomeRegionID
        {
            get;
            set;
        }

        /// <summary>
        /// The key of the home region
        /// </summary>
        public string HomeRegionKey
        {
            get;
            set;
        }

        /// <summary>
        /// The ID of this group's parent (Metadata).
        /// </summary>
        public Guid ParentGroupID
        {
            get;
            set;
        }

        /// <summary>
        /// The ID of this group's root (Metadata).
        /// </summary>
        public Guid RootGroupID
        {
            get;
            set;
        }

        /// <summary>
        /// This group's voice session code.
        /// </summary>
        public string VoiceSessionCode
        {
            get;
            set;
        }

        /// <summary>
        /// This group's message of the day.
        /// </summary>
        public string MessageOfTheDay
        {
            get;
            set;
        }

        /// <summary>
        /// This group's type.
        /// </summary>
        public GroupType GroupType
        {
            get;
            set;
        }

        /// <summary>
        /// This group's subtype.
        /// </summary>
        public GroupSubType GroupSubtype
        {
            get; 
            set;
        }

        /// <summary>
        /// The display order of this group (Metadata).
        /// </summary>
        public int DisplayOrder
        {
            get;
            set;
        }

        /// <summary>
        /// When true, this notification only includes: GroupID, ParentGroupID, RootGroupID and DisplayOrder.
        /// All other fields will be empty.
        /// </summary>
        public bool MetaDataOnly
        {
            get;
            set;
        }

        /// <summary>
        /// Whether or not this group allows temporary child groups to be created.
        /// </summary>
        public bool AllowTemporaryChildGroups { get; set; }

        /// <summary>
        /// Whether or not this group required push-to-talk in voice sessions.
        /// </summary>
        public bool ForcePushToTalk { get; set; }

        public GroupStatus Status { get; set; }

        public bool IsDefaultChannel { get; set; }

        /// <summary>
        /// An array of roles attached to this group
        /// </summary>
        public GroupRoleNotification[] Roles
        {
            get;
            set;
        }

        /// <summary>
        /// The effective permissions for a given role, for this channel.
        /// </summary>
        public Dictionary<int, Int64> RolePermissions
        {
            get;
            set;

        }

        public GroupMembershipNotification Membership
        {
            get;
            set;
        }


        public int MemberCount
        {
            get; 
            set;
        }

        public GroupEmoticonNotification[] Emotes
        {
            get; 
            set; 
        }

        public GroupMemberContract[] Members
        {
            get;
            set;
        }

        public ChannelContract[] Channels { get; set; }

        public GroupMode GroupMode { get; set; }

        public bool IsPublic { get; set; }

        /// <summary>
        /// The path of the URL for the group, ex: /league
        /// </summary>
        public string UrlPath { get; set; }

        /// <summary>
        /// The host URL for the group, ex: https://www.curse.com
        /// </summary>
        public string UrlHost { get; set; }

        /// <summary>
        /// If the chat throttle is enabled (Certain roles can bypass this)
        /// </summary>
        public bool ChatThrottleEnabled { get; set; }

        /// <summary>
        /// When the chat throttle is enabled, how often a message can be sent to a channel
        /// </summary>
        public int ChatThrottleSeconds { get; set; }

        /// <summary>
        /// Whether or not any of the community's linked accounts are currently streaming
        /// </summary>
        public bool IsStreaming { get; set; }

        /// <summary>
        /// Details about the communities linked to this group
        /// </summary>
        public ExternalCommunityPublicContract[] LinkedCommunities { get; set; }

        /// <summary>
        /// How long a user can be idle in a call, before being disconnected.
        /// </summary>
        public int AfkTimerMins { get; set; }

        /// <summary>
        /// The last time that the group's avatar was updated
        /// </summary>
        public long AvatarTimestamp { get; set; }

        /// <summary>
        /// Whether or not the group has been flagged as inappropriate
        /// </summary>
        public bool FlaggedAsInappropriate { get; set; }

        /// <summary>
        /// How many members are currently only
        /// </summary>
        public int MembersOnline { get; set; }

        public bool HideNoAccess { get; set; }
        public bool HideCallMembersNoAccess { get; set; }
        public ExternalGuildContract[] LinkedGuilds { get; set; }
        public string ExternalChannelID { get; set; }
    }
}
