﻿using System;
using System.Collections.Generic;
using Curse.Friends.Enums;
using Curse.SocketMessages;

namespace Curse.Friends.NotificationContracts
{    
    [ServiceContract(ServiceContractDirection.Embedded)]
    public class GroupPollNotification
    {
        /// <summary>
        /// The Group's ID
        /// </summary>        
        public Guid GroupID { get; set; }

        /// <summary>
        /// The Poll's ID
        /// </summary>
        public int PollID { get; set; }

        /// <summary>
        /// The Poll's title
        /// </summary>
        public string Title { get; set; }

        /// <summary>
        /// The Poll's options
        /// </summary>
        public Dictionary<int, string> Options { get; set; }

        /// <summary>
        /// The Poll's vote count by option (updated at an interval)
        /// </summary>
        public Dictionary<int, int> Votes { get; set; }

        /// <summary>
        /// The start time of the poll in Epoch milliseconds
        /// </summary>
        public long StartDate { get; set; }

        /// <summary>
        /// The roles required to vote if any
        /// </summary>
        public HashSet<int> RequiredRoles { get; set; }

        /// <summary>
        /// Whether or not the poll allows multiple selected options per vote
        /// </summary>
        public bool AllowMultipleSelections { get; set; }

        /// <summary>
        /// The type of display to use to show poll results
        /// </summary>
        public GroupPollDisplayType DisplayType { get; set; }

        /// <summary>
        /// THe status of the poll.
        /// </summary>
        public GroupPollStatus Status { get; set; }

        /// <summary>
        /// The code used to access the poll outside of the community.
        /// </summary>
        public string PublicCode { get; set; }

        /// <summary>
        /// The URL to access the public poll.
        /// </summary>
        public string PublicUrl { get; set; }

        /// <summary>
        /// Whether or not people can change their votes on the poll.
        /// </summary>
        public bool AllowRevotes { get; set; }

        public GroupPollDuplicateMode DuplicationMode { get; set; }

        public long? MillisecondsLeft { get; set; }
    }
}
