﻿using System;
using Curse.Friends.Enums;
using Curse.SocketMessages;
using ProtoBuf;

namespace Curse.Friends.NotificationContracts
{
    [ProtoContract]
    [EncryptedContract]
    [ServiceContract]
    public class GroupPreferenceNotification : Contract<GroupPreferenceNotification>
    {
        public GroupPreferenceNotification()
        {
            Timestamp = DateTime.UtcNow;
        }

        [ProtoMember(1)]
        public Guid GroupID { get; set; }

        [ProtoMember(2)]
        public NotificationPreference Preference { get; set; }

        [ProtoMember(3)]
        public bool IsFavorite { get; set; }
        
        [ProtoMember(4)]
        public DateTime Timestamp { get; set; }
    }
}
